// Jasmine Unit Testing Suite
define([
    'backbone',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-month-collection',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-date-collection',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-collection',
], function (Backbone, TimeSlotsByMonthCollection, TimeSlotsByDateCollection, TimeSlotsCollection) {
    'use strict';

    describe('Time Slots by Month Collection', function () {
        var collection;
        var timeSlotsByDateCollection = new TimeSlotsByDateCollection([
            {
                date: '10/08/2015',
                timeSlots: new TimeSlotsCollection(),
            },
            {
                date: '10/09/2015',
                timeSlots: new TimeSlotsCollection(),
            },
            {
                date: '11/11/2015',
                timeSlots: new TimeSlotsCollection(),
            },
            {
                date: '11/13/2015',
                timeSlots: new TimeSlotsCollection(),
            },
            {
                date: '11/15/2015',
                timeSlots: new TimeSlotsCollection(),
            },
            {
                date: '01/02/2016',
                timeSlots: new TimeSlotsCollection(),
            },
        ]);

        describe('when initialized from a collection of time slots by date', function () {
            beforeEach(function () {
                collection = new TimeSlotsByMonthCollection(null, {fromTimeSlotsByDateCollection: timeSlotsByDateCollection});
            });

            it('creates models by month', function () {
                var date = new Date('10/01/2015');
                date.setHours(0, 0, 0, 0);
                expect(collection.at(0).toJSON()).toEqual({
                    date: date,
                    id: 'october-2015',
                    monthNameYear: 'October 2015',
                    timeSlotsByDateCollection: collection.at(0).get('timeSlotsByDateCollection')
                        .toJSON(),
                });

                date = new Date('11/01/2015');
                date.setHours(0, 0, 0, 0);
                expect(collection.at(1).toJSON()).toEqual({
                    date: date,
                    id: 'november-2015',
                    monthNameYear: 'November 2015',
                    timeSlotsByDateCollection: collection.at(1).get('timeSlotsByDateCollection')
                        .toJSON(),
                });

                date = new Date('01/01/2016');
                date.setHours(0, 0, 0, 0);
                expect(collection.at(2).toJSON()).toEqual({
                    date: date,
                    id: 'january-2016',
                    monthNameYear: 'January 2016',
                    timeSlotsByDateCollection: collection.at(2).get('timeSlotsByDateCollection')
                        .toJSON(),
                });
            });
        });
    });
});
